<?php
defined('JPATH_BASE') or die();
jimport('joomla.html.html');
jimport('joomla.form.formfield');//import the necessary class definition for formfield
class JFormFieldRadio extends JFormField
{   
    protected $type = 'radio';
	protected function getInput()
	{ 
	  $doc =& JFactory::getDocument();
	  $doc->addStyleSheet(JURI::root().'templates/vt_education/vtemtools/widgets/style.css');
      $doc->addScript(JURI::root().'templates/vt_education/vtemtools/widgets/radios/js/radios.js');
		
		$html = array();
		// Initialize some field attributes.
		$class = $this->element['class'] ? ' class="radio '.(string) $this->element['class'].'"' : ' class="vt_item"';
		// Start the radio field output.
		$html[] = '<fieldset id="'.$this->id.'"'.$class.'>';
		// Get the field options.
		$options = $this->getOptions();
		// Build the radio field output.
		foreach ($options as $i => $option) {
			// Initialize some option attributes.
			$checked	= ((string) $option->value == (string) $this->value) ? ' checked="checked"' : '';
			$class		= !empty($option->class) ? ' class="'.$option->class.'"' : '';
			$disabled	= !empty($option->disable) ? ' disabled="disabled"' : '';
			// Initialize some JavaScript option attributes.
			$onclick	= !empty($option->onclick) ? ' onclick="'.$option->onclick.'"' : '';
			$html[] = '<input type="radio" class="vteminput" id="'.$this->id.$i.'" name="'.$this->name.'"' .
					' value="'.htmlspecialchars($option->value, ENT_COMPAT, 'UTF-8').'"'
					.$checked.$class.$onclick.$disabled.'/>';
			$html[] = '<label for="'.$this->id.$i.'"'.$class.'>'.JText::alt($option->text, preg_replace('/[^a-zA-Z0-9_\-]/', '_', $this->fieldname)).'</label>';
		}
		// End the radio field output.
		$html[] = '</fieldset>';
		return implode($html);
	}
	/**
	 * Method to get the field options.
	 *
	 * @return	array	The field option objects.
	 * @since	1.6
	 */
	protected function getOptions()
	{
		// Initialize variables.
		$options = array();
		foreach ($this->element->children() as $option) {
			// Only add <option /> elements.
			if ($option->getName() != 'option') {
				continue;
			}
			// Create a new option object based on the <option /> element.
			$tmp = JHtml::_('select.option', (string) $option['value'], trim((string) $option), 'value', 'text', ((string) $option['disabled']=='true'));
			// Set some option attributes.
			$tmp->class = (string) $option['class'];
			// Set some JavaScript option attributes.
			$tmp->onclick = (string) $option['onclick'];
			// Add the option object to the result set.
			$options[] = $tmp;
		}
		reset($options);
		return $options;
	}
}
